export { BaseError, type BaseErrorOptions } from './base/base.error';
export { OperationalError, type OperationalErrorOptions } from './base/operational.error';
export { UnexpectedError, type UnexpectedErrorOptions } from './base/unexpected.error';
export { UserError, type UserErrorOptions } from './base/user.error';
export { ApplicationError } from '@n8n/errors';
export { ExpressionError } from './expression.error';
export { ExecutionCancelledError } from './execution-cancelled.error';
export { NodeApiError } from './node-api.error';
export { NodeOperationError } from './node-operation.error';
export { NodeSslError } from './node-ssl.error';
export { WebhookPathTakenError } from './webhook-taken.error';
export { WorkflowActivationError } from './workflow-activation.error';
export { WorkflowDeactivationError } from './workflow-deactivation.error';
export { WorkflowOperationError } from './workflow-operation.error';
export { SubworkflowOperationError } from './subworkflow-operation.error';
export { CliWorkflowOperationError } from './cli-subworkflow-operation.error';
export { TriggerCloseError } from './trigger-close.error';

export { NodeError } from './abstract/node.error';
export { ExecutionBaseError } from './abstract/execution-base.error';
export { ExpressionExtensionError } from './expression-extension.error';
export { DbConnectionTimeoutError } from './db-connection-timeout-error';
export { ensureError } from './ensure-error';
