# @n8n/i18n

A package for managing internationalization (i18n) in n8n's Frontend codebase. It provides a structured way to handle translations and localization, ensuring that the application can be easily adapted to different languages and regions.

## Table of Contents

- [Features](#features)
- [Contributing](#contributing)
- [License](#license)

## Features

- **Translation Management**: Simplifies the process of managing translations for different languages.
- **Localization Support**: Provides tools to adapt the application for different regions and cultures.
- **Easy Integration**: Seamlessly integrates with n8n's Frontend codebase, making it easy to implement and use.
- **Reusable Base Text**: Allows for the definition of reusable base text strings, reducing redundancy in translations.
- **Pluralization and Interpolation**: Supports pluralization and interpolation in base text strings, making it flexible for various use cases.
- **Versioned Nodes Support**: Facilitates the management of translations for nodes in versioned directories, ensuring consistency across different versions.
- **Documentation**: Comprehensive documentation to help developers understand and utilize the package effectively.

## Contributing

For more details, please read our [CONTRIBUTING.md](CONTRIBUTING.md).

## License

For more details, please read our [LICENSE.md](LICENSE.md).
